#|
I've been playing a bit with Vista and looked through your examples in the
data/corresp directory.  Most were 2-way tables; from the suicide example
I see that the data is structured as a rectangular table with two (or more)
variables assigned to rows or cols,

I was wondering whether there exist any easy ways to 'pivot' a variable from
rows to cols or vice-versa.  Eg., Here's the Titanic data.  I had put  
Survive, Age and Sex into the rows and later wanted to rearrange the
variables.
|#

(DATA "Titanic" 
:TITLE "Survival on the Titanic"
:ABOUT "Frequency data for passengers and crew on the Titanic, classified by Survival, Age, Sex, and Class.  From Dawson, 1995,  The ``unusual episode'' data revisited.  J. of Statistical Education, 3(3). Data provided by Michael Friendly."

:freq t
:row-label "Survive/Age/Sex"
:column-label "Class"
:VARIABLES '("Survive" "Age" "Gender" "Class" "Frequency")
:TYPES '("Category" "Category" "Category" "Category" "Numeric")

:DATA '(
"Lived"   "Adult"    "Male"    "1st"       57        
"Lived"   "Adult"    "Male"    "2nd"       14        
"Lived"   "Adult"    "Male"    "3rd"       75       
"Lived"   "Adult"    "Male"    "Crew"     192
"Lived"   "Adult"    "Female"  "1st"      140        
"Lived"   "Adult"    "Female"  "2nd"       80        
"Lived"   "Adult"    "Female"  "3rd"       76        
"Lived"   "Adult"    "Female"  "Crew"      20
"Lived"   "Child"    "Male"    "1st"        5        
"Lived"   "Child"    "Male"    "2nd"       11        
"Lived"   "Child"    "Male"    "3rd"       13         
"Lived"   "Child"    "Male"    "Crew"       0
"Lived"   "Child"    "Female"  "1st"        1        
"Lived"   "Child"    "Female"  "2nd"       13        
"Lived"   "Child"    "Female"  "3rd"       14         
"Lived"   "Child"    "Female"  "Crew"       0
"Died"    "Adult"    "Male"    "1st"      118       
"Died"    "Adult"    "Male"    "2nd"      154       
"Died"    "Adult"    "Male"    "3rd"      387       
"Died"    "Adult"    "Male"    "Crew"     670
"Died"    "Adult"    "Female"  "1st"        4        
"Died"    "Adult"    "Female"  "2nd"       13        
"Died"    "Adult"    "Female"  "3rd"       89         
"Died"    "Adult"    "Female"  "Crew"       3
"Died"    "Child"    "Male"    "1st"        0         
"Died"    "Child"    "Male"    "2nd"        0        
"Died"    "Child"    "Male"    "3rd"       35         
"Died"    "Child"    "Male"    "Crew"       0
"Died"    "Child"    "Female"  "1st"        0         
"Died"    "Child"    "Female"  "2nd"        0        
"Died"    "Child"    "Female"  "3rd"       17         
"Died"    "Child"    "Female"  "Crew"       0
 ))